package cn.com.duiba.wechat.server.api.param.templatepush;

import cn.com.duiba.wechat.server.api.constant.enums.PushScenesEnum;
import cn.com.duiba.wechat.server.api.dto.templatepush.TemplateParameterDTO;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TemplateParam implements Serializable {

    private static final long serialVersionUID = 1567982860927721565L;
    /**
     * 模版所需参数
     */
    TemplateParameterDTO templateParameterDTO;
    /**
     * 业务ID 奖品过期提醒防止重复提醒
     */
    private Long bizId;

    @NotNull(message = "openId不能为空")
    private String openId;

    /**
     * 推送场景 {@link PushScenesEnum}
     */
    @NotNull(message = "推送场景不能为空")
    private Integer pushScene;
}
