package cn.com.duiba.wechat.server.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.templatepush.ManualPushDTO;
import cn.com.duiba.wechat.server.api.dto.templatepush.ManualPushDetailDTO;
import cn.com.duiba.wechat.server.api.param.groupsendtask.IdParam;
import cn.com.duiba.wechat.server.api.param.manualpush.CreateManualPushParam;
import cn.com.duiba.wechat.server.api.param.manualpush.PageQueryParam;
import cn.com.duiba.wechat.server.api.param.manualpush.UpdateManualPushParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 手动推送管理
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemoteManualPushService {

    /**
     * 创建手动推送任务
     * @param pushParam 推送参数
     * @return 返回值
     * @throws BizException 业务异常
     */
   Long createManualPushConfig(CreateManualPushParam pushParam) throws BizException;

    /**
     * 更新手动推送记录
     * @param pushParam 参数
     * @return 操作结果
     * @throws BizException 业务异常
     */
   Boolean updateManualPushConfig(UpdateManualPushParam pushParam) throws BizException;

    /**
     * 撤销定时任务
     *
     * @param param 参数
     * @return 结果
     * @throws BizException 业务异常
     */
    Boolean revokePushConfigTask(IdParam param) throws BizException;

    /**
     * 分页查询手动推送记录
     * @param pageQueryParam 查询参数
     * @return 手动推送记录
     */
    PageResponse<ManualPushDTO> pageQuery(PageQueryParam pageQueryParam);

    /**
     * 根据ID获取任务详情
     * @param param ID
     * @return 任务详情
     */
    ManualPushDetailDTO getById(IdParam param) throws BizException;
}
