package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.material.DraftDto;
import cn.com.duiba.wechat.server.api.dto.material.MaterialDto;
import cn.com.duiba.wechat.server.api.dto.material.SendAllDto;
import cn.com.duiba.wechat.server.api.dto.material.SendAllStatusDto;
import cn.com.duiba.wechat.server.api.dto.material.WxMaterialDto;
import cn.com.duiba.wechat.server.api.dto.tag.WxBaseDto;
import cn.com.duiba.wechat.server.api.param.material.DraftQueryParam;
import cn.com.duiba.wechat.server.api.param.material.MaterialPreviewParam;
import cn.com.duiba.wechat.server.api.param.material.MaterialQueryParam;
import cn.com.duiba.wechat.server.api.param.material.MediaListUploadParam;
import cn.com.duiba.wechat.server.api.param.material.MediaSingleQueryParam;
import cn.com.duiba.wechat.server.api.param.material.MediaSingleUploadParam;
import cn.com.duiba.wechat.server.api.param.material.QuerySendAllStatusParam;
import cn.com.duiba.wechat.server.api.param.material.RemoteWxMaterialQueryParam;
import cn.com.duiba.wechat.server.api.param.material.SendAllParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author wangxukai
 * @description 素材接口
 * @date ：Created in 2022/1/10
 */
@AdvancedFeignClient
public interface RemoteWxMaterialService {

    /**
     * 查询素材列表
     * @param param
     * @return
     */
    PageResponse<MaterialDto> getMaterialList(MaterialQueryParam param);

    /**
     * 查询草稿列表
     * @param param
     * @return
     */
    PageResponse<DraftDto> getDraftList(DraftQueryParam param);

    /**
     * 素材预览
     * @param param
     * @return
     */
    WxBaseDto materialPreview(MaterialPreviewParam param);

    /**
     * 群发
     * @param param
     * @return
     */
    SendAllDto sendAll(SendAllParam param);

    /**
     * 查询群发状态
     * @param param
     * @return
     */
    SendAllStatusDto querySendAllStatus(QuerySendAllStatusParam param);

    /**
     * 查询素材id是否存在
     * @param param
     * @return
     */
    WxBaseDto queryMediaExist(MediaSingleQueryParam param);


    /**
     * 上传素材文件 访问次数多容易线程报警
     * @param param
     * @return 访问路径
     */
    @Deprecated
    String uploadMediaFile(MediaSingleUploadParam param);

    /**
     * 查询根据素材id列表
     * @param materialIdList
     * @return
     */
    List<WxMaterialDto> getByMaterialIds(List<String> materialIdList);

    /**
     * 根据id查询素材
     * @param id
     * @return
     */
    WxMaterialDto getById(Long id);

    /**
     * 分页查询素材
     * @param param
     * @return
     */
    PageResponse<WxMaterialDto> getMaterialDBList(RemoteWxMaterialQueryParam param);

    /**
     * 删除多余素材
     * @param materialIdList
     * @param type
     */
    void deleteOtherMaterial(List<String> materialIdList,Integer type);

    /**
     * 批量插入更新
     * @param wxMaterialDtoList
     */
    void batchInsert(List<WxMaterialDto> wxMaterialDtoList);

    /**
     * 上传多个文件素材
     * @param paramList
     * @return
     */
    void uploadMediaFileList(MediaListUploadParam paramList);
}
