package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.menu.MenuDTO;
import cn.com.duiba.wechat.server.api.param.menu.MenuParam;

/**
 * 微信菜单服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/1/27 6:00 下午
 **/
@AdvancedFeignClient
public interface RemoteWxMenuService {
    /**
     * 发布菜单
     *
     * @param menuParam
     * @throws BizException
     */
    void publishMenu(MenuParam menuParam) throws BizException;

    /**
     * 获取最近菜单
     *
     * @return
     */
    MenuDTO getCurMenu();


    /**
     * 获取本地最新菜单
     * @return
     */
    MenuDTO getCurLocalMenu();
}
