/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wechat.server.api.constant;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class RedisKeyGenerator {
    private static final String GROUP_SEND_COUNT_MINUTE = "WECHAT_SERVICE_GROUP_MINUTE_SEND_COUNT:{0}";
    private static final String GROUP_SEND_COUNT_DAY = "WECHAT_SERVICE_GROUP_DAY_SEND_COUNT:{0}";
    private static final String TASK_COUNT = "WECHAT_SERVICE_TASK_COUNT:{0}";
    private static final DateTimeFormatter MINUTE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private static final DateTimeFormatter DAY_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static String buildTaskCountKey(String taskId) {
        return MessageFormat.format(TASK_COUNT, taskId);
    }

    public static String buildGroupSendCountMinute() {
        return MessageFormat.format(GROUP_SEND_COUNT_MINUTE, MINUTE_FORMAT.format(LocalDateTime.now()));
    }

    public static String buildGroupSendCountDay() {
        return MessageFormat.format(GROUP_SEND_COUNT_DAY, DAY_FORMAT.format(LocalDateTime.now()));
    }
}

