package cn.com.wawa.manager.common.enums;

/**
 * Created by danke on 2018/1/4.
 * 娃娃机状态展示用枚举
 * code与WawaCatcherStatusEnum的val呼应
 */
public enum CatcherStatusEnums {

    OFFSHELF_WAIT(0, "下架待补齐"),
    ONSHELF_WAIT(1, "待补齐"),
    TESTING(2,"测试中");

    private int code;

    private String desc;

    CatcherStatusEnums(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CatcherStatusEnums get(int code) {
        for (CatcherStatusEnums item : CatcherStatusEnums.values()) {
            if (item.code == code) {
                return item;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
