package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.constant.Constants;
import cn.com.wawa.proxy.api.event.impl.ClientPushEvent;
import com.alibaba.fastjson.JSONObject;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

import java.net.InetSocketAddress;

/**
 * Created by danke on 2017/11/15.
 */
public abstract class ConnectionClient {

    private static final String OBJECT_FILTER = "objectFilter";
    private static final String HEART_BEAT = "heartbeat";
    private static final String LOGGER = "logger";

    //链接配置
    private ConnectionConfig connectionConfig;
    //链接会话
    private IoSession ioSession;
    //客户端链接
    private NioSocketConnector connector;
    //改客户端标识
    private Long useId;

    public void connect(String ip){//初始化
        this.connectionConfig = new ConnectionConfig.Builder(Constants.MainConstants.port).setIp(ip).build();
        connect();
    }

    private void connect() {
        connector = new NioSocketConnector();
        connector.setHandler(new IoHandlerAdapter() {
            @Override
            public void messageReceived(IoSession session, Object message) throws Exception {
                //super.messageReceived(session, message);
                ClientPushEvent meaaageSer = JSONObject.parseObject(JSONObject.toJSONString(message), ClientPushEvent.class);
                consumersReceived(session,meaaageSer);
            }
        });
        connector.getFilterChain().addLast(LOGGER, new LoggingFilter());
        connector.getFilterChain().addLast(OBJECT_FILTER, new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
        ConnectFuture future = null;
        try {
            future = connector.connect(new InetSocketAddress(connectionConfig.getIp(), connectionConfig.getPort()));
            future.awaitUninterruptibly();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            //第一次链接时自报家门,现在是伪实现,之后应该在推送中标注
            this.ioSession = future.getSession();
            ClientPushEvent clientPushEvent = new ClientPushEvent();
            clientPushEvent.setUseId(9527l);
            this.useId = ioSession.getId();
            ioSession.setAttribute("useId",9527l);
            ioSession.write(clientPushEvent);
        }
    }


    public void close(){
        if (null == connector)
            return;
        if (ioSession != null){
            ioSession.getCloseFuture().setClosed();
            ioSession.getCloseFuture().awaitUninterruptibly();
        }
        connector.dispose();
    }

    /**
     * 改方法接收服务端推送信息,具体业务需自己实现
     * 参数已经约定序列化完成
     * @param session
     * @param meaaageSer
     */
    public abstract void consumersReceived(IoSession session, ClientPushEvent meaaageSer);

    public ConnectionConfig getConnectionConfig() {
        return connectionConfig;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public IoSession getIoSession() {
        return ioSession;
    }

    public void setIoSession(IoSession ioSession) {
        this.ioSession = ioSession;
    }

    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }

    public NioSocketConnector getConnector() {
        return connector;
    }
}
