package cn.com.wawa.proxy.api.code;

import org.apache.mina.core.buffer.BufferDataException;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.serialization.ObjectSerializationDecoder;
import org.apache.mina.filter.codec.serialization.ObjectSerializationEncoder;

import java.nio.charset.Charset;

/**
 * Created by danke on 2017/11/14.
 */
public class HCodeFactory implements ProtocolCodecFactory {

    private final HEncoder encoder;
    private final HDecoder decoder;

    public HCodeFactory() {
        this(Charset.defaultCharset());
    }
    public HCodeFactory(Charset charSet) {
        this.encoder = new HEncoder(charSet);
        this.decoder = new HDecoder(charSet);
    }

    public ProtocolEncoder getEncoder(IoSession session) {
        return encoder;
    }

    public ProtocolDecoder getDecoder(IoSession session) {
        return decoder;
    }

}
