package cn.com.wawa.service.api.enums;

/**
 * 删除状态
 */
public enum DeletedEnum {

    NORMAL(0, "未删除"),
    DELETED(1, "删除");

    private int    value;
    private String desc;

    DeletedEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static DeletedEnum get(int value) {
        for (DeletedEnum item : DeletedEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
