package cn.com.wawa.service.api.enums;

/**
 *  申诉结果状态枚举
 */
public enum AppealResultStatusEnum {

    RETURN_COIN(1, "退币"),
    JUDGE_CATCHED(2, "判为抓中"),
    REJECT(3, "驳回");

    private int    value;
    private String desc;

    AppealResultStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static AppealResultStatusEnum get(int value) {
        for (AppealResultStatusEnum item : AppealResultStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
