package cn.com.wawa.service.api.enums;

/**
 * 抓到的娃娃订单状态
 */
public enum WinOrderStatusEnum {

    CHECK(0, "寄存中"),
    COCK(1, "待发货"),
    ALREADY(2, "已发货"),
    CONFISCATE(3, "娃娃被收回"),
    RECEIVED(4, "已领取");

    private int    value;
    private String desc;

    WinOrderStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static WinOrderStatusEnum get(int value) {
        for (WinOrderStatusEnum item : WinOrderStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
