package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.BannerDto;

@AdvancedFeignClient
public interface RemoteBannerService {
    BannerDto find(Long id);

    /**
     * insert or update
     * @param bannerDto
     * @return
     */
    Boolean save(BannerDto bannerDto);

    PagerResponse<BannerDto> page(PagerRequest pageRequest, Integer status);

    Boolean delete(Long id);

    /**
     * 设置权重
     * @param id
     * @param payload
     * @return
     */
    Boolean setPayload(Long id, Long payload);

    Boolean setStatus(Long id, Integer status);

    public Integer countByStatus(Integer status);

}
