package cn.com.wawa.service.api.enums;

/**
 * 娃娃机订单状态枚举
 */
public enum JoinOrderStatusEnum {

    CREATE(0, "创建"),
    CATCHED(1, "抓中"),
    NOT_CATCHED(2, "未抓中");

    private int    value;
    private String desc;

    JoinOrderStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static JoinOrderStatusEnum get(int value) {
        for (JoinOrderStatusEnum item : JoinOrderStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
