package cn.com.wawa.service.api.enums;

public enum RobotDialogTypeEnum {

    UNCHARGE_BEFORE_JOIN(1, "未充值用户进入房间且还没有进行抓取操作"),
    UNCAHRGE_NOCOIN_CATCHED(2,"未充值用户免费币耗尽，已抓中一只"),
    UNCAHRGE_NOCOIN_UNCATCHED(3,"未充值用户免费币耗尽，未抓中"),
    CHARGED_NO_COIN_CATCHED(4,"用户首充后币耗尽，未抓到第二只"),
    AFTER_DELIVERY(5,"第一次发货后");
    private int    value;
    private String desc;

    RobotDialogTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static RobotDialogTypeEnum get(int value) {
        for (RobotDialogTypeEnum item : RobotDialogTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
