package cn.com.wawa.service.api.enums;

/**
 *  用户位运算字段枚举
 */
public enum UserSwitchesEnum {

    NEW_BONUS(0, "是否发放了新人红包"),
    FIRST_CHARGE(1, "是否发放了首冲奖励"),
    INVITED_BONUS(2,"被邀请奖励"),
    RED_PACKAGE(3,"红包活动"),
    STRONG_GRAB_CHANCE(4,"是否发放了强抓不中再送机会"),
    EASEMOB_REG(5,"是否注册环信用户"),
    WELCOME_DIALOG(6,"是否发送过欢迎聊天，要结合注册时间判断"),
    DELEVERY_POP(7,"是否弹出过发货弹窗");

    private int    value;
    private String desc;

    UserSwitchesEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static UserSwitchesEnum get(int value) {
        for (UserSwitchesEnum item : UserSwitchesEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
