package cn.com.wawa.service.api.exception;

import cn.com.wawa.service.api.enums.ErrorCodeEnum;

/**
 * 业务异常处理
 * Created by gyf .
 * 16/10/23 .
 */
public class BusinessException extends RuntimeException {

    private static final long serialVersionUID = 8968235904335164571L;

    /**
     * HttpStatus状态码
     */
    private final int    httpStatus;
    /**
     * 外部错误
     */
    private final String outerErrorMsg;
    /**
     * 给到客户端的错误码
     */
    private final int    code;

    public BusinessException(int httpStatus, ErrorCodeEnum errorCode) {
        super(errorCode.getDesc());
        this.code = errorCode.getCode();
        this.outerErrorMsg = errorCode.getDesc();
        this.httpStatus = httpStatus;
    }

    public BusinessException(int httpStatus, ErrorCodeEnum errorCode, Throwable cause) {
        super(cause);
        this.code = errorCode.getCode();
        this.outerErrorMsg = errorCode.getDesc();
        this.httpStatus = httpStatus;
    }

    /**
     * 内部错误使用，直接返回给客户端的异常还是应该调用含有errorCode的构造函数
     * @param message
     */
    public BusinessException(String message) {
        super(message);
        this.httpStatus = 200;
        this.outerErrorMsg=message;
        this.code=ErrorCodeEnum.E100000.getCode();
    }

    public int getCode() {
        return code;
    }

    public int getHttpStatus() {
        return httpStatus;
    }

    public String getOuterErrorMsg() {
        return outerErrorMsg;
    }
}
