package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * Created by gyf .
 * 2017/10/24 .
 */
@AdvancedFeignClient
public interface RemoteWawaService {

    /**
     * 娃娃待选列表
     *
     * @return
     */
    List<WawaSelectedDto> findSelectedList();

    /**
     * 分页列表
     *
     * @param pagerRequest
     * @param state
     * @return
     */
    PagerResponse<WawaDto> page(PagerRequest pagerRequest, String wawaName, Integer state);

    /**
     * 删除娃娃机
     *
     * @param wawaId
     * @return
     */
    JsonResult delete(Long wawaId);

    /**
     * 保存,带id就是更新,不带id就是插入
     *
     * @param wawa
     * @return
     */
    Boolean save(WawaSaveDto wawa);

    /**
     * 查询单个用于编辑
     *
     * @param wawaId
     * @return
     */
    WawaEditDto find(Long wawaId);

    /**
     * 更新权重
     *
     * @param payload
     * @return
     */
    Boolean updatePayload(Long id, Long payload);

    /**
     * 更新采购状态
     *
     * @param id
     * @param purchaseState
     * @return
     */
    Boolean updatePurchaseState(Long id, Boolean purchaseState);

    List<WawaTypeDto> getWawaTypes();

    /**
     * 归档分页列表
     *
     * @param pagerRequest
     * @return
     */
    PagerResponse<WawaDto> recyclePage(PagerRequest pagerRequest, String wawaName);

    /**
     * 归档
     *
     * @param id
     * @return
     */
    JsonResult recycle(Long id);

    /**
     * 恢复
     *
     * @param id
     * @return
     */
    Boolean recovery(Long id);

    BigDecimal getCaughtRate(Long price, Long primCost, Long returnAwardRate);

    List<WawaDto> findByIds(List<Long> ids);
}
