package cn.com.wawa.service.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by gyf . 2017/10/27 .
 */
@Data
@ApiModel(value = "娃娃保存信息")
public class WawaSaveDto implements Serializable {

    private static final long serialVersionUID = 7041703886449031029L;

    private Long id;

    private String wawaName;

    private Long price;

    private Long primeCost;

    private String indexImage;
    /**
     * 抓娃娃电压配置，多段电压用","分隔，必须配置完整才会生效
     */
    private String voltage;

    private Integer wawaType;

    private List<String> wawaDetailPics;
    private String deliveryNum;

    private Long payload;
    @ApiModelProperty(value = "0：不展示 1：展示 2:仅抓中过娃娃的用户展示")
    private Integer homeShowStatus;
    /**
     * 娃娃在娃娃机中的投放数量
     */
    private Integer luanchQuantity;

    @ApiModelProperty(value = "首次必中  1-是   2-否(概率抓取)")
    private Integer catchType;
    @ApiModelProperty(value = "详情中的娃娃名称")
    private String detailWawaName;
    @ApiModelProperty(value = "详情中的详情描述")
    private String detailDescr;
    @ApiModelProperty("角标")
    private String cornerPic;
    @ApiModelProperty("上线时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date cornerOnTime;
    @ApiModelProperty("下线时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date cornerOffTime;
    @ApiModelProperty("返奖率")
    private Integer returnAwardRate;

    @ApiModelProperty("是否代抓")
    private Boolean replaceCatch;
    @ApiModelProperty("特价")
    private Long specialPrice;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("特价上线时间")
    private Date priceOnTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("特价下线时间")
    private Date priceOffTime;
    @ApiModelProperty("兑换券数量 0.不支持兑换")
    private Integer ticketNum;
    @ApiModelProperty("是否支持兑换 1.是 0.否")
    private Integer supportExchange;
}
