package cn.com.wawa.service.api.enums;

public enum ChargeFilterTypeEnum {

    USERID(1, "用户id过滤"),
    TWOYUAN(2, "2元充值");


    private int    value;
    private String desc;

    ChargeFilterTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static ChargeFilterTypeEnum get(int value) {
        for (ChargeFilterTypeEnum item : ChargeFilterTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
