package cn.com.wawa.service.api.enums;

public enum FloorStatusEnum {

    ENABLE(1, "上线"),
    DISABLE(2, "下线");

    private int value;
    private String desc;

    FloorStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static FloorStatusEnum get(int value) {
        for (FloorStatusEnum item : FloorStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }


}
