package cn.com.wawa.service.api.enums;

public enum RedPackageTypeEnum {
    CHARGE_BACK(1, "冲反红包"),
    GUARANTEE (2, "保底红包"),
    JOIN_NUMBER(3, "抓取次数红包"),
    WIN_NUMBER(4,"抓中次数红包"),
    CHARGE_BACK_NEW(5, "新冲反红包"),
    GUARANTEE_NEW (6, "新保底红包"),
    GUARANTEE_V3 (7, "直接开启的保底红包");

    private int    value;
    private String desc;

    RedPackageTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static RedPackageTypeEnum get(int value) {
        for (RedPackageTypeEnum item : RedPackageTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
