package cn.com.wawa.service.api.enums;

/**
 * 娃娃机的玩法
 */
public enum WawaCatcherPlayTypeEnum {

    CLASSIC(1, "经典玩法"),
    TIME_LIMIT(2, "限时玩法");

    private int    value;
    private String desc;

    WawaCatcherPlayTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static WawaCatcherPlayTypeEnum get(int value) {
        for (WawaCatcherPlayTypeEnum item : WawaCatcherPlayTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
