package cn.com.wawa.service.api.enums;

/**
 * 抓到的娃娃订单状态
 */
public enum WinOrderStatusEnum {

    CHECK(0, "寄存中"),
    COCK(1, "待发货"),
    ALREADY(2, "已发货"),
    CONFISCATE(3, "娃娃被收回"),
    RECEIVED(4, "已领取"),

    IN_TRANSIT(5, "在途中"),
    COLLECTED(6, "已揽收"),
    DIFFICULT(7, "疑难"),
    SIGN_IN(8, "已签收"),
    SIGN_OUT(9, "退签"),
    SENDING(10, "同城派送中"),
    RETURN(11, "退回"),
    TURN(12, "转单"),
    PAST_DUE(13,"已过期,可兑换%s币"),
    CONVERSION(14,"已兑换成%s抓抓币");

    private int value;
    private String desc;

    WinOrderStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static WinOrderStatusEnum get(int value) {
        for (WinOrderStatusEnum item : WinOrderStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
