package cn.com.wawa.service.api.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * Created by danke on 2018/2/7.
 * 用户信息修改更新query
 */
@ApiModel("用户信息修改更新query")
public class UserInfoChangeQuery implements Serializable {

    @ApiModelProperty("用户id")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickName;

    @ApiModelProperty("用户头像")
    private String localAvatar;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getLocalAvatar() {
        return localAvatar;
    }

    public void setLocalAvatar(String localAvatar) {
        this.localAvatar = localAvatar;
    }

    public void checkVal(){
        this.nickName = StringUtils.isBlank(nickName)? null : this.nickName;
        this.localAvatar = StringUtils.isBlank(localAvatar)? null : this.localAvatar;
    }
}
