package cn.com.wawa.service.api.tools;

import java.math.BigDecimal;

/**
 * 金额工具类
 */
public class BigDecimalUtil {

    /**
     * 私有构造器
     */
    private BigDecimalUtil() {
        // Do nothing because of X and Y.
    }

    /**
     * 将Integer类型的数据向左偏移一定的位数
     *
     * @param src      数据源
     * @param moveLeft 向左偏移位数
     * @return
     */
    public static BigDecimal integerToMovePointLeft(Integer src, int moveLeft) {
        if (src == null) {
            return null;
        }
        return BigDecimal.valueOf(src).movePointLeft(moveLeft);
    }

    /**
     * 将Integer类型的数据向左偏移2位数
     *
     * @param src 数据源
     * @return
     */
    public static BigDecimal integerToMove2PointLeft(Integer src) {
        return integerToMovePointLeft(src, 2);
    }

    /**
     * 将BigDecimal类型的数据向右偏移2位数得到整形数字
     *
     * @param src 数据源
     * @return int
     */
    public static int integerToMove2PointRigth(BigDecimal src) {
        return integerToMovePointRigth(src, 2);
    }

    /**
     * 将BigDecimal类型的数据向右偏移一定的位数得到整形数字
     *
     * @param src       数据源
     * @param moveRigth 向右偏移位数
     * @return
     */
    public static int integerToMovePointRigth(BigDecimal src, int moveRigth) {
        if (src == null) {
            return -1;
        }
        return src.movePointRight(moveRigth).intValue();
    }
}
