package cn.com.wawa.service.api.dto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Api("消息中心dto")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CenterMsgDto {
    @ApiModelProperty("消息id")
    private Long id;

    @ApiModelProperty("消息名称")
    private String msgName;

    @ApiModelProperty("消息类型 1-活动信息 2-系统通知 3-娃娃动态")
    private Integer msgType;

    @ApiModelProperty("消息类型描述")
    private String msgTypeDescr;

    @ApiModelProperty("消息标题")
    private String msgTitle;

    @ApiModelProperty("消息内容")
    private String msgContent;

    @ApiModelProperty("图片")
    private String msgPic;

    @ApiModelProperty("跳转url")
    private String url;

    @ApiModelProperty("目标用户类型 1-全推  2-部分用户")
    private Integer targetUserType;

    @ApiModelProperty("目标用户类型描述")
    private String targetUserTypeDescr;

    @ApiModelProperty("推送用户文件")
    private String userIdsFile;

    @ApiModelProperty("发送时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime;

    @ApiModelProperty("消息状态")
    private Integer msgStatus;

    @ApiModelProperty("消息状态描述 1-未发送  2-待发送 3-已发送  4-删除")
    private String msgStatusDescr;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date gmtCreate;
}
