package cn.com.wawa.service.api.dto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 娃娃
 */
@Data
@ApiModel(value = "娃娃信息")
public class WawaDto implements Serializable {

    private static final long serialVersionUID = -181429783319351596L;

    private Long              id;

    private String            wawaName;

    private Long              price;

    private Long              primeCost;

    private String            indexImage;

    private Integer           deleted;

    private List<Long>        sellerCatcherIds;

    private Date              gmtCreate;

    private Date              gmtModified;

    /** 抓娃娃电压配置，多段电压用","分隔，必须配置完整才会生效 */
    private String            voltage;

    private GoodsType             goodsType;

    private List<String>        detailPics;
    private String            deliveryNum;

    private Long payload;

    private Integer homeShowStatus;
    /**娃娃在娃娃机中的投放数量*/
    private Integer luanchQuantity;

    @ApiModelProperty(value = "概率")
    private BigDecimal rate;

    private String cornerPic;

    @ApiModelProperty("返奖率")
    private Integer returnAwardRate;

    @ApiModelProperty("抓取类型 1-首次必中 2-概率抓取")
    private Integer catchType;

    @ApiModelProperty("是否代抓")
    private Boolean replaceCatch;

    @ApiModelProperty("上下架状态 1.上架 0.下架")
    private Integer state;

    @ApiModelProperty("采购状态 true.采购 false.不采购")
    private Boolean purchaseState;

    @ApiModelProperty("特价")
    private Long specialPrice;
    @ApiModelProperty("特价上线时间")
    private Date priceOnTime;
    @ApiModelProperty("特价下线时间")
    private Date priceOffTime;
    @ApiModelProperty("兑换券数量")
    private Integer ticketNum;
    @ApiModelProperty("是否支持兑换券 1.是 0.否")
    private Integer supportExchange;
    @ApiModelProperty("娃娃类目")
    private String categoryName;
    @ApiModelProperty("是否支持兑换抓抓币 1.是 0.否")
    private Integer exchangeCoin;
}
