package cn.com.wawa.service.api.enums;

public enum ErrorCodeEnum {

    E100000(100000,"未定义错误"),
    E100001(100001, "未登录"),
    E100002(100002, "无权操作"),
    E100003(100003,"在其他客户端登录"),
    E999999(999999, "系统错误"),

    E100100(100100, "娃娃机维护"),
    E100101(100101, "娃娃机被占用"),
    E100102(100102, "娃娃机被占用(未抢占到)"),
    E100103(100103, "您的抓抓币不足，请充值！"),
    E100104(100104, "通知接收到的订单,不是该用户的订单"),
    E100105(100105, "5秒内不能重复开始抓"),
    E100107(100107, "娃娃机不存在"),
    E100108(100108, "抓娃娃订单不存在"),
    E100109(100109, "娃娃不存在"),
    E100110(100110, "游戏时间未到"),

    E100200(100200,"已领取过首充奖励"),

    E100300(100300, "抓中订单不存在"),
    E100301(100301, "用户提交发货的订单,有不是他自己的"),
    E100302(100302, "用户提交发货的订单,有不是寄存中状态的"),
    E100303(100303, "用户没填写地址"),

    E100401(100401,"获取签名失败"),
    E100501(100501,"黑名单用户"),

    E100601(100601,"分享类型不合法"),

    E100701(100701,"申诉订单不存在"),
    E100702(100702,"游戏记录订单不存在"),
    E100703(100703,"参数非法||为空"),
    E100704(100704,"未进行微信授权"),

    E100705(100705,"申诉订单已处理，不能重复处理"),
    E100706(100706,"结果为未抓中的join订单，但是却存在win订单"),
    E100707(100707,"结果为已抓中的join订单，但是不存在win订单"),
    E100708(100708,"join订单状态异常"),

    E100801(100801,"用户正在匹配中"),
    E100802(100802,"无空闲娃娃机");
    private int code;

    private String desc;

    private ErrorCodeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * code.
     *
     * @return the code
     */
    public int getCode() {
        return code;
    }

    /**
     * desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }
}
