package cn.com.wawa.service.api.enums;

/**
 * 充值费率配置
 */
public enum ChargeBonusConfigTypeEnum {

    NORMAL(1, "普通"),
    FIRST_CHARGE(2, "首冲");

    private int    value;
    private String desc;

    ChargeBonusConfigTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static ChargeBonusConfigTypeEnum get(int value) {
        for (ChargeBonusConfigTypeEnum item : ChargeBonusConfigTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
