package cn.com.wawa.service.api.enums;

public enum ErrorCodeEnum {

    E100000(100000,"未定义错误"),
    E100001(100001, "未登录"),
    E100002(100002, "无权操作"),
    E999999(999999, "系统错误"),

    E100100(100100, "娃娃机维护"),
    E100101(100101, "娃娃机被占用"),
    E100102(100102, "娃娃机被占用(未抢占到)"),
    E100103(100103, "用户抓抓币不足"),
    E100104(100104, "通知接收到的订单,不是该用户的订单"),
    E100105(100105, "5秒内不能重复开始抓"),
    E100107(100107, "娃娃机不存在"),
    E100108(100108, "抓娃娃订单不存在"),
    E100109(100109, "娃娃不存在"),

    E100200(100200,"已领取过首冲奖励"),

    E100300(100300, "抓中订单不存在"),
    E100301(100301, "用户提交发货的订单,有不是他自己的"),
    E100302(100302, "用户提交发货的订单,有不是寄存中状态的"),
    E100303(100303, "用户没填写地址");
    private int code;

    private String desc;

    private ErrorCodeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * code.
     *
     * @return the code
     */
    public int getCode() {
        return code;
    }

    /**
     * desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }
}
