package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.WawaCatcherDto;
import cn.com.wawa.service.api.dto.WawaCatcherSaveDto;
import cn.com.wawa.service.api.dto.WawaCatcherSimpleDto;
import cn.com.wawa.service.api.enums.WawaCatcherOperateEnum;

/**
 * Created by gyf .
 * 2017/10/27 .
 */
@AdvancedFeignClient
public interface RemoteWawaCatcherService {

    /**
     * 分页
     * @param pagerRequest
     * @return
     */
    PagerResponse<WawaCatcherDto> page(PagerRequest pagerRequest);

    /**
     * 更新权重
     * @param catcherId
     * @param payload
     * @return
     */
    Boolean updatePayload(Long catcherId, Long payload);

    /**
     * 删除娃娃机
     * @param catcherId
     * @return
     */
    Boolean delete(Long catcherId);

    /**
     * 更新状态
     * @param catcherId
     * @param operate
     * @return
     */
    Boolean updateStatus(Long catcherId, WawaCatcherOperateEnum operate);

    /**
     * 保存,带id就是更新,不带id就是插入
     * @param catcher
     * @return
     */
    Boolean save(WawaCatcherSaveDto catcher);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    WawaCatcherSimpleDto find(Long id);
}
