package cn.com.wawa.common.constants;

/**
 * Created by gyf .
 * 2017/10/25 .
 */
public class RedisNamespace {

    private RedisNamespace() {
    }

    /**
     * 娃娃机用户订单标记
     * key 娃娃机id
     * value 订单id+userid
     * 时间5分钟
     */
    public static final String CATCHER_ORDER = "wawa:catcher:order:%s";

    /**
     * 围观用户数组
     * key: wawa:catcher:onlookers:{catcherId}
     * value: json
     * expire_time: 1800
     * 有新来的，就把 json 解析成一个 map，(用户 id + 头像)然后进行删除和新增操作，然后再转成 json 存回去
     * 插入、更新：
     * 用户进房间，没有就插入。
     * 用户进房间，有就更新。
     * 用户出房间，没有就不操作，有就更新。
     * 用户上机，没有就不操作，有就更新。
     * 用户玩完一局，没有就插入，有就更新。
     * 移除：过期时间到（自动）
     */
    public static final String CATCHER_ONLOOKERS = "wawa:catcher:onlookers:%s";

    /**
     * 围观用户插入锁
     */
    public static final String CATCHER_ONLOOKERS_LOCK = "wawa:catcher:onlookers:lock:%s";

    /**
     * 弹幕列表
     * 娃娃机游戏中状态，存在 redis 中
     * key:  wawa:catcher:barrage:{catcherId}
     * value: userId + 结果
     * expire_time: 5
     * 插入：娃娃机抓取结果通知过来后
     * 移除：过期自动移除
     * 5秒轮询一次
     */
    public static final String CATCHER_BARRAGE = "wawa:catcher:barrage:%s";

    /**
     * 娃娃机游戏中用户
     * 娃娃机游戏中状态，存在 redis 中
     * key:  wawa:catcher:gaming:user:{catcherId}
     * value: userId
     * expire_time: 60 (游戏进行时间为30s，但是出来充值弹窗后，娃娃机还是他的)
     * 插入/更新失效时间：用户开始上机玩，玩了一次继续玩，玩完一次更新倒计时10秒？
     * 移除： 用户主动放弃、用户点击返回、过期时间到（自动）
     */
    public static final String CATCHER_GAMING = "wawa:catcher:gaming:user:%s";

    /**
     * 娃娃机游戏用户锁
     */
    public static final String CATCHER_GAMING_LOCK = "wawa:catcher:gaming:lock:%s";

    /**
     * 用户登录身份accesstoken
     */
    public static final String USER_ACCESS_TOKEN = "wawa:catcher:token:%s";

    /**
     * 用户老的用户登录身份accesstoken
     */
    public static final String USER_ACCESS_TOKEN_OLD = "wawa:catcher:token:old:%s";

    /**
     * 腾讯直播签名sig缓存
     */
    public static final String USER_LIVE_SIG="wawa:user:sig:%s";

    /**
     * 该次抓娃娃的过程中,用户中途离开游戏.需要记下来.等服务端收到娃娃机结果通知的时候,不做倒计时操作
     * key : wawa:catcher:leave:{orderId}
     * value : userId
     */
    public static final String CATCHER_LEAVE_SIG = "wawa:catcher:leave:%s";

    /**
     * 娃娃机充值回调锁
     */
    public static final String CHARGE_ORDER_LOCK="wawa:charge:lock:%s";

    /**
     * 版本更新测试用户
     */
    public static final String VERSION_TEST_USER="wawa:version:test:%s";

    /**
     * 用户获取版本信息的日期
     */
    public static final String GET_VERSION_USER="wawa:version:get:version:";

    /**
     * 推送消息
     */
    public static final String JPUSH_MSG_USER="wawa:jpush:msg:%s";
}
