package cn.com.wawa.common.tool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.regex.Pattern;

/**
 * get ip
 *
 * @author sunchangji
 */
public class IpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpUtil.class);

    private static final String ANYHOST = "0.0.0.0";
    private static final String LOCALHOST = "127.0.0.1";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");

    private static volatile InetAddress localAddress = null;

    private IpUtil() {
    }

    /**
     * valid address
     *
     * @param address
     * @return
     */
    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress())
            return false;
        String name = address.getHostAddress();
        return (name != null
                && !ANYHOST.equals(name)
                && !LOCALHOST.equals(name)
                && IP_PATTERN.matcher(name).matches());
    }

    /**
     * get first valid addredd
     *
     * @return
     */
    private static InetAddress getFirstValidAddress() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (isValidAddress(localAddress)) {
                return localAddress;
            }
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces == null) {
                return localAddress;
            }
            while (interfaces.hasMoreElements()) {
                NetworkInterface network = interfaces.nextElement();
                Enumeration<InetAddress> addresses = network.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (isValidAddress(address)) {
                        return address;
                    }
                }
            }
        } catch (Exception e) {
            LOGGER.error("Failed to retriving ip address", e);
        }
        LOGGER.warn("Could not get local host ip address, will use 127.0.0.1 instead.");
        return localAddress;
    }

    /**
     * get address
     *
     * @return
     */
    private static InetAddress getAddress() {
        if (localAddress != null)
            return localAddress;
        localAddress = getFirstValidAddress();
        if(localAddress != null){
            LOGGER.warn("本机外网IP={}",localAddress.getHostAddress());
        }
        return localAddress;
    }

    /**
     * get ip
     *
     * @return
     */
    public static String getIp() {
        InetAddress address = getAddress();
        if (address == null) {
            return LOCALHOST;
        }
        return address.getHostAddress();
    }

}
