package cn.com.wawa.common.tool;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * MD5工具类
 */
public class MD5 {

    private static final Logger LOG         = LoggerFactory.getLogger(MD5.class);
    private static String       hexDigits[] = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d",
            "e", "f"                       };

    /**
     * 构造方法
     */
    public MD5() {
        // 暂不需要处理
    }

    /**
     * @param b
     * @return
     * @throws NoSuchAlgorithmException
     */
    public static String md5(byte b[]) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(b, 0, b.length);
        return byteArrayToHexString(md5.digest());
    }

    /**
     * @param data
     * @return
     * @throws NoSuchAlgorithmException
     * @throws UnsupportedEncodingException
     */
    public static String md5(String data) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte b[] = data.getBytes("UTF8");
            md5.update(b, 0, b.length);
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
            LOG.warn("MD5加密失败, data=" + data, e);
            return null;
        }
        return byteArrayToHexString(md5.digest());
    }

    private static String byteArrayToHexString(byte b[]) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; i++)
            sb.append(byteToHexString(b[i]));

        return sb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) n = 256 + n;
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

}
