package cn.com.wawa.common.tool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Value;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 访问E店宝接口用到的信息如何获取文档--> http://vip13.edb08.com.cn/mongolog/EAOPHandler.ashx?_id=94b0473980374bfb9c8d395aec73dc67
 */
public class EdbLib {

    private static final Logger LOGGER = LoggerFactory.getLogger(EdbLib.class);

    /**
     * 主账号
     */
    private String              dbhost;

    private String              appkey;

    private String              appscret;

    private String              token;

    private String              serviceUrl;

    /**
     * 获取公共参数
     *
     * @param method 接口名称
     * @return 公共参
     */
    public Map<String, String> edbGetCommonParams(String method) {
        Map<String, String> map = new HashMap<>();
        map.put("method", method);// 接口名称
        map.put("dbhost", this.dbhost);
        map.put("appkey", this.appkey);
        map.put("format", "JSON");// 返回的数据格式
        map.put("timestamp", new SimpleDateFormat("yyyyMMddHHmm").format(new Date()));// timestamp
        // 全小写
        map.put("v", "2.0");// 版本号
        map.put("slencry", "1");
        map.put("ip", IpUtil.getIp());// 本机ip
        return map;
    }

    /**
     * @param params 参数(不要包含appscret和token)
     * @return 服务回应
     */
    public String edbRequstPost(Map<String, String> params) {
        params.put("sign", edbSignature(params));
        return HttpClientUtil.sendPost(this.serviceUrl, params);
    }

    /**
     * 签名
     *
     * @param params 参数
     * @return 签名结果
     */
    private String edbSignature(Map<String, String> params) {
        Map<String, String> treeMap = new TreeMap<>(new Comparator<String>() {

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        treeMap.putAll(params);
        treeMap.put("appscret", this.appscret);
        treeMap.put("token", this.token);
        // 拼接要签名的字符串
        StringBuilder builder = new StringBuilder(appkey);
        for (Iterator<String> iterator = treeMap.keySet().iterator(); iterator.hasNext();) {
            String key = iterator.next();
            if ("".equals(key) || "".equals(treeMap.get(key))) {
                continue;
            }
            builder.append(key).append(treeMap.get(key));
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(builder.toString().getBytes("utf-8"));
            builder.setLength(0);
            for (byte b : bytes) {
                String hx = Integer.toHexString(b & 0XFF);
                builder.append(hx.length() == 1 ? "0" + hx : hx);
            }
            return builder.toString().toUpperCase();
        } catch (Exception e) {
            LOGGER.warn("", e);
            return "签名异常";
        }
    }

    public static Logger getLOGGER() {
        return LOGGER;
    }

    public String getDbhost() {
        return dbhost;
    }

    public void setDbhost(String dbhost) {
        this.dbhost = dbhost;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getAppscret() {
        return appscret;
    }

    public void setAppscret(String appscret) {
        this.appscret = appscret;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getServiceUrl() {
        return serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }
}
