package cn.com.wawa.common.tool;

import cn.com.wawa.common.constants.RedisNamespace;

public class RedisKeyUtil {

    public static String getUserContinueWinNumKey(Long userId) {
        return String.format(RedisNamespace.USER_CONTINUE_WIN_NUM, userId);
    }

    public static String getShowUserTitle(Long userId, int secondType) {
        return String.format(RedisNamespace.SHOW_USER_TITLE_TYPE, userId, secondType);
    }

    /**
     * 用户称号信息key
     *
     * @param userId
     * @return
     */
    public static String getUserConfigLevel(Long userId) {
        return String.format(RedisNamespace.USER_TITLE_CONFIG_LEVEL, userId);
    }

    /**
     * 系统应用配置key
     *
     * @param id 应用id
     * @return
     */
    public static String getAppConfig(Long id) {
        return String.format(RedisNamespace.SYSTEM_APP_CONFIG, id);
    }

    /**
     * H5 access_token key
     * @param accessToken
     * @return
     */
    public static String getWxH5AccessToken(String accessToken) {
        return String.format(RedisNamespace.WX_H5_ACCESS_TOKEN, accessToken);
    }

    public static String getWxH5JsApiTicket(String jsApiTicket) {
        return String.format(RedisNamespace.WX_H5_JS_API_TICKET, jsApiTicket);
    }
}
