/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.common.tool;

import com.alibaba.fastjson.JSONObject;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class JsonRender
extends JSONObject {
    private static final long serialVersionUID = -466686765952338133L;
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String CALLBACK = "callback";
    private static final String DATA = "data";

    private JsonRender() {
    }

    public static JsonRender successResult() {
        JsonRender resp = new JsonRender();
        resp.put(SUCCESS, true);
        resp.put(DATA, new HashMap());
        return resp;
    }

    public static JsonRender successResult(JSONObject model) {
        JsonRender resp = JsonRender.successResult();
        ((Map)resp.get(DATA)).putAll(model);
        return resp;
    }

    public JsonRender addALL(Map<String, Object> params) {
        JsonRender resp = JsonRender.successResult();
        ((Map)resp.get(DATA)).putAll(params);
        return resp;
    }

    public static JsonRender failResult(String message) {
        JsonRender resp = new JsonRender();
        resp.put(SUCCESS, false);
        resp.put(MESSAGE, message);
        return resp;
    }

    public static JsonRender failResult(Throwable e) {
        JsonRender resp = new JsonRender();
        resp.put(SUCCESS, false);
        resp.put(MESSAGE, e.getMessage());
        return resp;
    }

    public JsonRender setJSONPCallback(String callback) {
        this.put(CALLBACK, callback);
        return this;
    }

    public boolean isSuccess() {
        return this.getBoolean(SUCCESS);
    }

    public String getMessage() {
        return this.getString(MESSAGE);
    }

    public JsonRender setMessage(String message) {
        this.put(MESSAGE, message);
        return this;
    }

    public JsonRender addResult(String key, Object result) {
        ((Map)this.get(DATA)).put(key, result);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forJsonpReturn(HttpServletResponse response, String callback) {
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.write(callback + "(" + this.toJSONString() + ")");
        }
    }
}

