/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.exception;

import cn.hutool.core.text.CharSequenceUtil;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.enums.ResultUtil;
import cn.lili.common.exception.ServiceException;
import cn.lili.common.vo.ResultMessage;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalControllerExceptionHandler.class);
    static Integer MAX_LENGTH = 200;

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResultMessage<Object> handleServiceException(HttpServletRequest request, Exception e, HttpServletResponse response) {
        if (e instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)e;
            ResultCode resultCode = serviceException.getResultCode();
            Integer code = null;
            String message = null;
            if (resultCode != null) {
                code = resultCode.code();
                message = resultCode.message();
            }
            if (message != null && !serviceException.getMsg().equals("\u7f51\u7edc\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01")) {
                message = this.appendErrorMessage(message, serviceException.getMsg());
            }
            assert (serviceException.getResultCode() != null);
            if (serviceException.getResultCode().equals((Object)ResultCode.DEMO_SITE_EXCEPTION)) {
                log.debug("[DEMO_SITE_EXCEPTION]:{}", (Object)serviceException.getResultCode().message(), (Object)e);
                return ResultUtil.error(code, message);
            }
            if (serviceException.getResultCode().equals((Object)ResultCode.USER_AUTH_EXPIRED)) {
                log.debug("403 :{}", (Object)serviceException.getResultCode().message(), (Object)e);
                return ResultUtil.error(code, message);
            }
            log.error("\u5168\u5c40\u5f02\u5e38[ServiceException]:{}-{}", new Object[]{serviceException.getResultCode().code(), serviceException.getResultCode().message(), e});
            return ResultUtil.error(code, message);
        }
        log.error("\u5168\u5c40\u5f02\u5e38[ServiceException]:", (Throwable)e);
        String errorMsg = "\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
        if (e != null && e.getMessage() != null && e.getMessage().length() < MAX_LENGTH) {
            errorMsg = e.getMessage();
        }
        return ResultUtil.error(ResultCode.ERROR.code(), errorMsg);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResultMessage<Object> runtimeExceptionHandler(HttpServletRequest request, Exception e, HttpServletResponse response) {
        log.error("\u5168\u5c40\u5f02\u5e38[RuntimeException]:", (Throwable)e);
        return ResultUtil.error(ResultCode.ERROR);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ResultMessage<Object> validExceptionHandler(HttpServletRequest request, Exception e, HttpServletResponse response) {
        BindException exception = (BindException)e;
        List fieldErrors = exception.getBindingResult().getFieldErrors();
        Iterator iterator = fieldErrors.iterator();
        if (iterator.hasNext()) {
            FieldError error = (FieldError)iterator.next();
            return ResultUtil.error(ResultCode.PARAMS_ERROR.code(), error.getDefaultMessage());
        }
        return ResultUtil.error(ResultCode.PARAMS_ERROR);
    }

    private String appendErrorMessage(String message, String appendMessage) {
        if (message.contains(appendMessage)) {
            return message;
        }
        if (appendMessage.contains(message)) {
            return appendMessage;
        }
        return CharSequenceUtil.format((CharSequence)"{}:{}", (Object[])new Object[]{message, appendMessage});
    }
}

