/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.security.filter;

import cn.hutool.http.HtmlUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);
    private static final String[] allowedTags = new String[]{"h1", "h2", "h3", "h4", "h5", "h6", "span", "strong", "em", "img", "video", "source", "iframe", "code", "blockquote", "p", "div", "font", "ul", "ol", "li", "hr", "table", "thead", "caption", "tbody", "tr", "th", "td", "br", "a"};
    private static final String[] needTransformTags = new String[]{"article", "aside", "command", "datalist", "details", "figcaption", "figure", "footer", "header", "hgroup", "section", "summary", "font"};
    private static final String[] linkTags = new String[]{"img", "video", "source", "a", "iframe", "p"};
    private static final String[] allowAttributes = new String[]{"style", "src", "href", "target", "width", "height", "color", "font"};

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null) {
            return new String[0];
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.filterXss(name, values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value == null) {
            return null;
        }
        return this.filterXss(name, value);
    }

    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        if (value instanceof String) {
            value = this.filterXss(name, (String)value);
        }
        return value;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value == null) {
            return null;
        }
        return this.filterXss(name, value);
    }

    public Map<String, String[]> getParameterMap() {
        Map parameterMap = super.getParameterMap();
        LinkedHashMap<String, String[]> params = new LinkedHashMap<String, String[]>();
        if (parameterMap != null) {
            for (Map.Entry entry : parameterMap.entrySet()) {
                String[] values = (String[])entry.getValue();
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    values[i] = value = this.filterXss((String)entry.getKey(), value);
                }
                params.put((String)entry.getKey(), values);
            }
        }
        return params;
    }

    /*
     * Exception decompiling
     */
    public ServletInputStream getInputStream() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String cleanXSS(String value) {
        if (value != null) {
            PolicyFactory policy = new HtmlPolicyBuilder().allowStandardUrlProtocols().allowElements(allowedTags).allowElements((elementName, attributes) -> "div", needTransformTags).allowAttributes(allowAttributes).onElements(linkTags).allowStyling().toFactory();
            value = policy.sanitize(value);
        }
        return HtmlUtil.unescape((String)value);
    }

    private String filterXss(String name, String value) {
        return this.cleanXSS(value);
    }
}

