/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.threadpool.wrapper;

import cn.lili.common.threadpool.factory.NamedThreadFactory;
import cn.lili.common.threadpool.policy.AbortPolicyWithReport;
import cn.lili.common.threadpool.properties.ThreadPoolProperties;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ThreadPoolExecutorWrapper
extends ThreadPoolTaskExecutor
implements AsyncTaskExecutor,
ExecutorService,
SmartLifecycle {
    public ThreadPoolExecutorWrapper(String threadPoolName, ThreadPoolProperties poolProperties) {
        this.setThreadNamePrefix(threadPoolName);
        Objects.requireNonNull(threadPoolName);
        Objects.requireNonNull(poolProperties);
        this.setRejectedExecutionHandler(new AbortPolicyWithReport(threadPoolName));
        this.setThreadFactory(new NamedThreadFactory(threadPoolName));
        this.setCorePoolSize(poolProperties.getCoreSize());
        this.setMaxPoolSize(Math.max(poolProperties.getMaxSize(), poolProperties.getCoreSize()));
        this.setQueueCapacity(poolProperties.getQueueSize());
    }

    protected ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return super.initializeExecutor(threadFactory, rejectedExecutionHandler);
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.getThreadPoolExecutor().shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.getThreadPoolExecutor().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.getThreadPoolExecutor().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.getThreadPoolExecutor().awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.getThreadPoolExecutor().submit(task, result);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.getThreadPoolExecutor().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getThreadPoolExecutor().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.getThreadPoolExecutor().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getThreadPoolExecutor().invokeAny(tasks, timeout, unit);
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isRunning() {
        return !this.getThreadPoolExecutor().isTerminating() && !this.getThreadPoolExecutor().isTerminated();
    }

    public int getPhase() {
        return -2;
    }

    public String getThreadPoolName() {
        return this.getThreadNamePrefix();
    }

    protected ThreadPoolExecutor getInnerThreadPoolExecutor() {
        return this.getThreadPoolExecutor();
    }

    public void destroy() {
    }
}

