/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.HttpUtil;
import com.xkcoding.http.config.HttpConfig;
import com.xkcoding.http.support.AbstractHttp;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.support.httpclient.HttpClientImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    public static final int HTTP_CONN_TIMEOUT = 100000;
    public static final int HTTP_SOCKET_TIMEOUT = 100000;

    public HttpUtils(HttpConfig config) {
        HttpUtil.setConfig((HttpConfig)config);
        HttpUtil.setHttp((AbstractHttp)new HttpClientImpl());
    }

    public HttpUtils() {
    }

    public String get(String url) {
        return HttpUtil.get((String)url);
    }

    public String get(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        return HttpUtil.get((String)url, params, (HttpHeader)header, (boolean)encode);
    }

    public String post(String url) {
        return HttpUtil.post((String)url);
    }

    public String post(String url, String data) {
        return HttpUtil.post((String)url, (String)data);
    }

    public String post(String url, String data, HttpHeader header) {
        return HttpUtil.post((String)url, (String)data, (HttpHeader)header);
    }

    public String post(String url, Map<String, String> params, boolean encode) {
        return HttpUtil.post((String)url, params, (boolean)encode);
    }

    public String post(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        return HttpUtil.post((String)url, params, (HttpHeader)header, (boolean)encode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String reqUrl, Map<String, Object> parameters, String encoding, int connectTimeout, int readTimeout) {
        HttpURLConnection urlConn = null;
        try {
            urlConn = HttpUtils.sendPost(reqUrl, parameters, encoding, connectTimeout, readTimeout);
            String responseContent = HttpUtils.getContent(urlConn, encoding);
            String string = responseContent.trim();
            return string;
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }

    public static String doPostWithJson(String reqUrl, Map<String, String> jsonParameters) {
        BufferedReader reader = null;
        try {
            String line;
            URL url = new URL(reqUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
            out.append(JSONObject.toJSONString(jsonParameters));
            out.flush();
            out.close();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            String res = "";
            while ((line = reader.readLine()) != null) {
                res = res + line;
            }
            reader.close();
            return res;
        }
        catch (IOException e) {
            log.error("post\u8bf7\u6c42\u9519\u8bef", (Throwable)e);
            return "error";
        }
    }

    public static String doPostWithJson(String reqUrl, Object object) {
        BufferedReader reader = null;
        try {
            String line;
            URL url = new URL(reqUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
            out.append(JSONObject.toJSONString((Object)object));
            out.flush();
            out.close();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            String res = "";
            while ((line = reader.readLine()) != null) {
                res = res + line;
            }
            reader.close();
            return res;
        }
        catch (IOException e) {
            log.error("post\u9519\u8bef", (Throwable)e);
            return "error";
        }
    }

    private static HttpURLConnection sendPost(String reqUrl, Map<String, Object> parameters, String encoding, int connectTimeout, int readTimeout) {
        HttpURLConnection urlConn = null;
        try {
            String params = HttpUtils.generatorParamString(parameters, encoding);
            URL url = new URL(reqUrl);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("POST");
            urlConn.setConnectTimeout(connectTimeout);
            urlConn.setReadTimeout(readTimeout);
            urlConn.setDoOutput(true);
            byte[] b = params.getBytes(encoding);
            urlConn.getOutputStream().write(b, 0, b.length);
            urlConn.getOutputStream().flush();
            urlConn.getOutputStream().close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return urlConn;
    }

    private static String getContent(HttpURLConnection urlConn, String encoding) {
        try {
            String responseContent = null;
            InputStream in = urlConn.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(in, encoding));
            String tempLine = rd.readLine();
            StringBuffer tempStr = new StringBuffer();
            String crlf = System.getProperty("line.separator");
            while (tempLine != null) {
                tempStr.append(tempLine);
                tempStr.append(crlf);
                tempLine = rd.readLine();
            }
            responseContent = tempStr.toString();
            rd.close();
            in.close();
            return responseContent;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String doGet(String link, String encoding, int connectTimeout, int readTimeout) {
        HttpURLConnection conn = null;
        try {
            String s;
            URL url = new URL(link);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) > 0) {
                out.write(buf, 0, i);
            }
            out.flush();
            String string = s = out.toString(encoding);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
    }

    public static String generatorParamString(Map<String, Object> parameters, String encoding) {
        StringBuffer params = new StringBuffer();
        if (parameters != null) {
            Iterator<String> iter = parameters.keySet().iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                Object value = parameters.get(name);
                params.append(name + "=");
                try {
                    params.append(URLEncoder.encode(value.toString(), encoding));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (Exception e) {
                    String message = String.format("'%s'='%s'", name, value);
                    throw new RuntimeException(message, e);
                }
                if (!iter.hasNext()) continue;
                params.append("&");
            }
        }
        return params.toString();
    }
}

