/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.security.token;

import cn.lili.cache.Cache;
import cn.lili.cache.CachePrefix;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.common.properties.JWTTokenProperties;
import cn.lili.common.security.AuthUser;
import cn.lili.common.security.enums.SecurityEnum;
import cn.lili.common.security.enums.UserEnums;
import cn.lili.common.security.token.SecretKeyUtil;
import cn.lili.common.security.token.Token;
import com.google.gson.Gson;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.SignatureException;
import java.security.Key;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenUtil {
    @Autowired
    private JWTTokenProperties tokenProperties;
    @Autowired
    private Cache cache;

    public Token createToken(AuthUser authUser) {
        Token token = new Token();
        String accessToken = this.createToken(authUser, this.tokenProperties.getTokenExpireTime());
        this.cache.put(CachePrefix.ACCESS_TOKEN.getPrefix(authUser.getRole()) + accessToken, 1, this.tokenProperties.getTokenExpireTime(), TimeUnit.MINUTES);
        Long expireTime = Boolean.TRUE.equals(authUser.getLongTerm()) ? 21600L : this.tokenProperties.getTokenExpireTime() * 2L;
        String refreshToken = this.createToken(authUser, expireTime);
        this.cache.put(CachePrefix.REFRESH_TOKEN.getPrefix(authUser.getRole()) + refreshToken, 1, expireTime, TimeUnit.MINUTES);
        token.setAccessToken(accessToken);
        token.setRefreshToken(refreshToken);
        return token;
    }

    public Token refreshToken(String oldRefreshToken) {
        Claims claims;
        try {
            claims = (Claims)Jwts.parserBuilder().setSigningKey((Key)SecretKeyUtil.generalKeyByDecoders()).build().parseClaimsJws(oldRefreshToken).getBody();
        }
        catch (ExpiredJwtException | MalformedJwtException | UnsupportedJwtException | SignatureException | IllegalArgumentException e) {
            throw new ServiceException(ResultCode.USER_AUTH_EXPIRED);
        }
        String json = claims.get((Object)SecurityEnum.USER_CONTEXT.getValue()).toString();
        AuthUser authUser = (AuthUser)new Gson().fromJson(json, AuthUser.class);
        UserEnums userEnums = authUser.getRole();
        boolean longTerm = authUser.getLongTerm();
        if (this.cache.hasKey(CachePrefix.REFRESH_TOKEN.getPrefix(userEnums) + oldRefreshToken)) {
            Token token = new Token();
            String accessToken = this.createToken(authUser, this.tokenProperties.getTokenExpireTime());
            this.cache.put(CachePrefix.ACCESS_TOKEN.getPrefix(userEnums) + accessToken, 1, this.tokenProperties.getTokenExpireTime(), TimeUnit.MINUTES);
            long expirationTime = this.tokenProperties.getTokenExpireTime() * 2L;
            if (longTerm) {
                expirationTime = 21600L;
                authUser.setLongTerm(true);
            }
            String refreshToken = this.createToken(authUser, expirationTime);
            this.cache.put(CachePrefix.REFRESH_TOKEN.getPrefix(userEnums) + refreshToken, 1, expirationTime, TimeUnit.MINUTES);
            token.setAccessToken(accessToken);
            token.setRefreshToken(refreshToken);
            this.cache.remove(CachePrefix.REFRESH_TOKEN.getPrefix(userEnums) + oldRefreshToken);
            return token;
        }
        throw new ServiceException(ResultCode.USER_AUTH_EXPIRED);
    }

    private String createToken(AuthUser authUser, Long expirationTime) {
        return Jwts.builder().claim(SecurityEnum.USER_CONTEXT.getValue(), (Object)new Gson().toJson((Object)authUser)).setSubject(authUser.getUsername()).setExpiration(new Date(System.currentTimeMillis() + expirationTime * 60L * 1000L)).signWith((Key)SecretKeyUtil.generalKey()).compact();
    }
}

