/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.sensitive;

import cn.lili.common.sensitive.SensitiveWordsNode;
import cn.lili.common.sensitive.StringPointer;
import java.io.Serializable;
import java.util.List;
import java.util.NavigableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveWordsFilter
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SensitiveWordsFilter.class);
    public static final char WILDCARD_STAR = '*';
    static final int DEFAULT_INITIAL_CAPACITY = 131072;
    protected static SensitiveWordsNode[] nodes = new SensitiveWordsNode[0];
    protected static SensitiveWordsNode[] nodesUpdate;

    public static String filter(String sentence) {
        return SensitiveWordsFilter.filter(sentence, '*');
    }

    public static String filter(String sentence, char replace) {
        int step;
        StringPointer sp = new StringPointer("  " + sentence + "  ");
        boolean replaced = false;
        block0: for (int i = 0; i < sp.length - 2; i += step) {
            step = 1;
            int hash = sp.nextTwoCharHash(i);
            if (nodes.length == 0) {
                return sentence;
            }
            SensitiveWordsNode node = nodes[hash & nodes.length - 1];
            if (node == null) continue;
            int mix = sp.nextTwoCharMix(i);
            while (node != null) {
                NavigableSet<StringPointer> desSet;
                if (node.headTwoCharMix == mix && (desSet = node.words.headSet(sp.substring(i), true)) != null) {
                    for (StringPointer word : desSet.descendingSet()) {
                        if (!sp.nextStartsWith(i, word)) continue;
                        sp.fill(i, i + word.length, replace);
                        step = word.length;
                        replaced = true;
                        continue block0;
                    }
                }
                node = node.next;
            }
        }
        if (replaced) {
            String res = sp.toString();
            return res.substring(0, res.length() - 2);
        }
        return sentence;
    }

    public static void init(List<String> words) {
        log.info("\u5f00\u59cb\u521d\u59cb\u5316\u654f\u611f\u8bcd");
        nodesUpdate = new SensitiveWordsNode[131072];
        for (String word : words) {
            SensitiveWordsFilter.put(word);
        }
        nodes = nodesUpdate;
    }

    public static boolean put(String word) {
        if (word == null || word.trim().length() < 2) {
            return false;
        }
        if (word.length() == 2 && word.matches("\\w\\w")) {
            return false;
        }
        StringPointer sp = new StringPointer(word.trim());
        int hash = sp.nextTwoCharHash(0);
        int mix = sp.nextTwoCharMix(0);
        int index = hash & nodesUpdate.length - 1;
        SensitiveWordsNode node = nodesUpdate[index];
        if (node == null) {
            node = new SensitiveWordsNode(mix);
            node.words.add(sp);
            SensitiveWordsFilter.nodesUpdate[index] = node;
        } else {
            while (node != null) {
                if (node.headTwoCharMix == mix) {
                    node.words.add(sp);
                    return true;
                }
                if (node.next == null) {
                    new SensitiveWordsNode((int)mix, (SensitiveWordsNode)node).words.add(sp);
                    return true;
                }
                node = node.next;
            }
        }
        return true;
    }

    public static void remove(String word) {
        StringPointer sp = new StringPointer(word.trim());
        int hash = sp.nextTwoCharHash(0);
        int mix = sp.nextTwoCharMix(0);
        int index = hash & nodes.length - 1;
        SensitiveWordsNode node = nodes[index];
        while (node != null) {
            if (node.headTwoCharMix == mix) {
                node.words.remove(sp);
            }
            node = node.next;
        }
    }
}

