package cn.lili.common.redisExt;

import cn.lili.cache.config.redis.FastJsonRedisSerializer;
import cn.lili.common.utils.SpringEnvironmentUtils;
import org.assertj.core.util.Lists;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author yuquanfeng
 * @Date 2023/5/26
 * @Description
 * @Param
 * @return
 **/
@Component
public class RedisExtTemplatePostProcessor implements BeanDefinitionRegistryPostProcessor, EnvironmentAware {

    private static final String redisExtraIdPrefix = "duiba.redis.extra.";

    private static final String redisExtraIdSuffix = ".host";

    private BeanDefinitionRegistry beanDefinitionRegistry;


    private List<String> extRedisName = Lists.newArrayList();

    private static final String JEDIS_CONNECTION_FACTORY_BEAN_DESTROY_METHOD_NAME = "destroy";


    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        if(extRedisName == null || extRedisName.isEmpty()){
            return;
        }
        for(String extraRedisTemplateIdPrefix : extRedisName) {
            String redisConnectionFactoryBeanId = extraRedisTemplateIdPrefix + "RedisConnectionFactory";
            if(beanDefinitionRegistry.containsBeanDefinition(redisConnectionFactoryBeanId)){
                break;
            }
            BeanDefinition extraRedisConnectionFactoryDefinition = BeanDefinitionBuilder
                    .genericBeanDefinition(JedisConnectionFactoryBean.class)
                    .setDestroyMethodName(JEDIS_CONNECTION_FACTORY_BEAN_DESTROY_METHOD_NAME)
                    .addConstructorArgValue(extraRedisTemplateIdPrefix)
                    .getBeanDefinition();
            beanDefinitionRegistry.registerBeanDefinition(redisConnectionFactoryBeanId, extraRedisConnectionFactoryDefinition);

            String extRedisTemplateBeanName = extraRedisTemplateIdPrefix + "RedisTemplate";
            BeanDefinition extraRedisTemplateDefinition = BeanDefinitionBuilder
                    .genericBeanDefinition(RedisTemplate.class)
                    .addPropertyReference("connectionFactory", redisConnectionFactoryBeanId)
                    .addPropertyValue("defaultSerializer", new FastJsonRedisSerializer(Object.class))
                    .getBeanDefinition();
            beanDefinitionRegistry.registerBeanDefinition(extRedisTemplateBeanName, extraRedisTemplateDefinition);

            String extStringRedisTemplateBeanName = extraRedisTemplateIdPrefix + "StringRedisTemplate";
            BeanDefinition extraStringRedisTemplateDefinition = BeanDefinitionBuilder
                    .genericBeanDefinition(StringRedisTemplate.class)
                    .addPropertyReference("connectionFactory", redisConnectionFactoryBeanId)
                    .getBeanDefinition();
            beanDefinitionRegistry.registerBeanDefinition(extStringRedisTemplateBeanName, extraStringRedisTemplateDefinition);
        }
    }

    @Override
    public void setEnvironment(Environment environment) {

        LinkedHashMap<String, Object> flatEnvironments = SpringEnvironmentUtils.getFlatEnvironments(environment);
        for (Map.Entry<String, Object> entry : flatEnvironments.entrySet()) {
            if (!entry.getKey().startsWith(redisExtraIdPrefix)) {
                continue;
            }
            int prefixLength = redisExtraIdPrefix.length();
            if (entry.getKey().endsWith(redisExtraIdSuffix)) {
                extRedisName.add(entry.getKey().substring(prefixLength, entry.getKey().length() - redisExtraIdSuffix.length()));
            }
        }
    }
}
