package cn.lili.common.threadpool.factory;

import cn.lili.common.threadpool.properties.ThreadPoolConfig;
import cn.lili.common.threadpool.properties.ThreadPoolProperties;
import cn.lili.common.threadpool.wrapper.ThreadPoolExecutorWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;
import java.util.Objects;

/**
 * @Author yuquanfeng
 * @Date 2023/5/25
 * @Description
 * @Param
 * @return
 **/
public class ThreadPoolFactoryBean implements FactoryBean<ThreadPoolExecutorWrapper> {


    @Autowired
    private ThreadPoolConfig duibaThreadPoolConfig;

    private String threadPoolName;

    @Override
    public ThreadPoolExecutorWrapper getObject(){

        Objects.requireNonNull(threadPoolName);

        Map<String, ThreadPoolProperties> extra = duibaThreadPoolConfig.getExtra();

        ThreadPoolProperties properties;
        if(StringUtils.equals(threadPoolName, ThreadPoolProperties.DEFAULT_BEAN_NAME)){
            properties = duibaThreadPoolConfig.getDefaultThreadPoolProperties();
        }else{
            properties = extra.get(threadPoolName);
        }
        if (properties == null) {
            throw new IllegalArgumentException("缺失线程池"+threadPoolName+"的配置");
        }
        ThreadPoolExecutorWrapper wrapper = new ThreadPoolExecutorWrapper(threadPoolName, properties);
        wrapper.afterPropertiesSet();
        return wrapper;
    }

    @Override
    public Class<?> getObjectType() {
        return ThreadPoolExecutorWrapper.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String getThreadPoolName() {
        return threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }
}
