package cn.lili.common.threadpool.properties;

import com.google.common.collect.Maps;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @Author yuquanfeng
 * @Date 2023/5/25
 * @Description
 * @Param
 * @return
 **/
@ConfigurationProperties(prefix = "duiba.threadpool")
@Component
public class ThreadPoolConfig extends ThreadPoolProperties{

    public static final Integer THREAD_MAX_SIZE = 2000;

    private Boolean enabled = false;

    private Map<String,ThreadPoolProperties> extra = Maps.newHashMap();

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, ThreadPoolProperties> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, ThreadPoolProperties> extra) {
        this.extra = extra;
    }

    public ThreadPoolProperties getDefaultThreadPoolProperties(){
        if(extra.containsKey(ThreadPoolProperties.DEFAULT_BEAN_NAME)){
            return extra.get(ThreadPoolProperties.DEFAULT_BEAN_NAME);
        }
        ThreadPoolProperties properties = new ThreadPoolProperties();
        BeanUtils.copyProperties(this,properties);
        return properties;
    }
    /**
     *
     * @return
     */
    public Integer getMaxSizeCount(){
        Integer count = 0;
        for(ThreadPoolProperties poolProperties:extra.values()){
            count += poolProperties.getMaxSize();
        }
        if(!extra.containsKey(ThreadPoolProperties.DEFAULT_BEAN_NAME)){
            count += this.getMaxSize();
        }
        return count;
    }
}
