package cn.lili.common.utils;

import org.springframework.context.ConfigurableApplicationContext;

/**
 * @Author yuquanfeng
 * @Date 2023/5/26
 * @Description
 * @Param
 * @return
 **/
public class MainApplicationContextHolder {

    private MainApplicationContextHolder(){}

    private static volatile ConfigurableApplicationContext applicationContext;

    /**
     * 外部方法禁止调用此方法
     * @param applicationContext
     */
    public static void _setApplicationContext(ConfigurableApplicationContext applicationContext) {
        if(MainApplicationContextHolder.applicationContext != null &&
                MainApplicationContextHolder.applicationContext.isActive()){
            throw new IllegalStateException("外部方法禁止调用_setApplicationContext");
        }
        MainApplicationContextHolder.applicationContext = applicationContext;
    }

    /**
     * 获取当前应用的applicationContext
     * @return
     */
    public static ConfigurableApplicationContext getApplicationContext() {
        return applicationContext;
    }
}
