package cn.lili.common.vo;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2023/6/8
 * @Description
 **/
public class PageResult<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 列表数据
     */
    private List<T> records = Collections.emptyList();
    /**
     * 总数
     */
    private Integer total = 0;
    /**
     * 当前页
     */
    private Integer current = 1;
    /**
     * 每页条数
     */
    private Integer size = 10;


    public Integer getPages() {
        if (this.getSize() == 0L) {
            return 0;
        } else {
            int pages = this.getTotal() / this.getSize();
            if (this.getTotal() % this.getSize() != 0L) {
                ++pages;
            }
            return pages;
        }
    }


    public PageResult() {
    }

    public PageResult(Integer total, Integer current, Integer size, List<T> records){
        this.total = total;
        this.current = current;
        this.size = size;
        this.records = records;
    }

    public List<T> getRecords() {
        return records;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getCurrent() {
        return current;
    }

    public void setCurrent(Integer current) {
        this.current = current;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }
}
