/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.mybatis.util;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.lili.common.utils.BeanUtil;
import cn.lili.common.utils.StringUtils;
import cn.lili.common.vo.PageVO;
import cn.lili.common.vo.SearchVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PageUtil {
    public static <T> Page<T> initPage(PageVO page) {
        Page p;
        int pageNumber = page.getPageNumber();
        int pageSize = page.getPageSize();
        String sort = page.getSort();
        String order = page.getOrder();
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        if (pageSize > 100) {
            pageSize = 100;
        }
        if (StrUtil.isNotBlank((CharSequence)sort)) {
            Boolean isAsc = false;
            if (StrUtil.isBlank((CharSequence)order)) {
                isAsc = false;
            } else if ("desc".equals(order.toLowerCase())) {
                isAsc = false;
            } else if ("asc".equals(order.toLowerCase())) {
                isAsc = true;
            }
            p = new Page((long)pageNumber, (long)pageSize);
            if (isAsc.booleanValue()) {
                p.addOrder(new OrderItem[]{OrderItem.asc((String)sort)});
            } else {
                p.addOrder(new OrderItem[]{OrderItem.desc((String)sort)});
            }
        } else {
            p = new Page((long)pageNumber, (long)pageSize);
        }
        return p;
    }

    public static <T> QueryWrapper<T> initWrapper(Object object) {
        return PageUtil.initWrapper(object, null);
    }

    public static <T> QueryWrapper<T> initWrapper(Object object, SearchVO searchVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (searchVo != null && StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
            DateTime start = DateUtil.parse((CharSequence)searchVo.getStartDate());
            DateTime end = DateUtil.parse((CharSequence)searchVo.getEndDate());
            queryWrapper.between((Object)"create_time", (Object)start, (Object)DateUtil.endOfDay((Date)end));
        }
        if (searchVo != null && StrUtil.isNotBlank((CharSequence)searchVo.getInColumn())) {
            if (searchVo.getInColumnValue() != null && searchVo.getInColumnValue().size() > 0) {
                queryWrapper.in((Object)searchVo.getInColumn(), (Collection)searchVo.getInColumnValue());
            }
            if (searchVo.getInColumnValue() != null && searchVo.getInColumnValue().size() == 0) {
                queryWrapper.in((Object)searchVo.getInColumn(), Arrays.asList("0"));
            }
        }
        if (object != null) {
            String[] fieldNames;
            for (String key : fieldNames = BeanUtil.getFiledName((Object)object)) {
                Object value = BeanUtil.getFieldValueByName((String)key, (Object)object);
                if (value == null || "".equals(value)) continue;
                queryWrapper.eq((Object)StringUtils.camel2Underline((String)key), value);
            }
        }
        return queryWrapper;
    }

    public static <T> List<T> listToPage(PageVO page, List<T> list) {
        int pageNumber = page.getPageNumber() - 1;
        int pageSize = page.getPageSize();
        if (pageNumber < 0) {
            pageNumber = 0;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        if (pageSize > 100) {
            pageSize = 100;
        }
        int fromIndex = pageNumber * pageSize;
        int toIndex = pageNumber * pageSize + pageSize;
        if (fromIndex > list.size()) {
            return new ArrayList();
        }
        if (toIndex >= list.size()) {
            return list.subList(fromIndex, list.size());
        }
        return list.subList(fromIndex, toIndex);
    }

    public static <T> Page<T> convertPage(Page originPage, List<T> records) {
        Page resultPage = new Page();
        if (originPage != null) {
            resultPage.setCurrent(originPage.getCurrent());
            resultPage.setPages(originPage.getPages());
            resultPage.setTotal(originPage.getTotal());
            resultPage.setSize(originPage.getSize());
            resultPage.setRecords(records);
        }
        return resultPage;
    }
}

