package cn.lili.rocketmq.consumer;

import cn.lili.rocketmq.consumer.annotation.TagSub;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author yuquanfeng
 * @Date 2023/5/25
 * @Description
 * @Param
 * @return
 **/
@Slf4j
public abstract class AbstractMessageHandler {
    /**
     * 消费消息的具体逻辑
     * @param message 消息体
     * @param reConsumerTimes 重试次数
     * @param topic 主题
     * @param tag tag
     * @throws Exception
     */
    public void consumer(String message, int reConsumerTimes, String topic, String tag) throws Exception{
        try {
            doConsumer(message);
        }catch (Exception e){
            if(needReConsumer(reConsumerTimes)){
                throw e;
            }
            log.error("AbstractMessageHandler consumer error topic:{}, tag:{}, message:{}, handlerName:{}", topic, tag, message, getTagName());
        }
    }

    /**
     * 具体的消费逻辑（由消费者自己实现）
     * @param message 消息体
     */
    protected abstract void doConsumer(String message);


    /**
     * 当消息消费异常的时候是否需要重复消费
     * @param reConsumerTimes
     * @return
     */
    protected boolean needReConsumer(int reConsumerTimes){
        return true;
    }

    /**
     * 获取到@TagSub注解上的值
     * @return
     */
    public   String getTagName(){
        return this.getClass().getDeclaredAnnotation(TagSub.class).tag();
    }

}
